PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144440556"
 Author = "jayas.jayas"
 Desc = "Single Transmission Line (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots")
  {
  Desc = ""
  FileDate = 1144440545
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([54,72],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1098]
    Posn = [54,72]
    Icon = [-1,-1]
    Extents = 0,0,738,1098
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,264],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39014592,"V1a",0,,,)
     Curve(38966448,"V1b",1,,,)
     Curve(38951864,"V1c",2,,,)
     }
    Graph([0,264],[0,0,738,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39012600,"I1a",0,,,)
     Curve(38972248,"I1b",1,,,)
     Curve(39026288,"I1c",2,,,)
     }
    Graph([0,527],[0,0,738,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39036624,"I10",0,,,)
     }
    PGraph([0,790],[0,0,738,245],"PolyGraph")
     {
     Options = 2
     Curve(38959496,"Br1a",0,,,1)
     Curve(38968440,"Br1b",1,,,1)
     Curve(39006656,"Br1c",2,,,1)
     }
    }
   -Plot-([810,72],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,738,1098]
    Posn = [810,72]
    Icon = [-1,-1]
    Extents = 0,0,738,1098
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,264],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38953856,"V2a",0,,,)
     Curve(38955848,"V2b",1,,,)
     Curve(38984416,"V2c",2,,,)
     }
    Graph([0,264],[0,0,738,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(38947520,"I2a",0,,,)
     Curve(38949872,"I2b",1,,,)
     Curve(39028288,"I2c",2,,,)
     }
    Graph([0,527],[0,0,738,263],"Current")
     {
     Options = 9
     Units = ""
     Curve(39039152,"I20",0,,,)
     }
    PGraph([0,790],[0,0,738,245],"PolyGraph")
     {
     Options = 2
     Curve(38962640,"Br2a",0,,,1)
     Curve(38970344,"Br2b",1,,,1)
     Curve(38964544,"Br2c",2,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144440545
  Nodes = 
   {
   Input("FType",36,-18)
    {
    Type = Integer
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([72,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,198,198,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(39046632)
    Dial(39112008)
    Slider(38907032)
    Slider(38909120)
    Slider(39061056)
    }
   -Wire-([1116,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datamerge([1386,1098],4,0,180)
    {
    N = "2"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1368,1026],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1368,1044],6,0,-1)
    {
    Name = "B2"
    }
   0.export([1422,1134],4,0,170)
    {
    Name = "F"
    }
   0.datalabel([990,684],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([990,738],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([990,792],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([954,684],0,38785120,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.33"
    Units = "s"
    Collect = "1"
    }
   0.var([954,738],0,38786792,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   0.var([954,792],0,38788768,60)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.33"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([954,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,198,1062,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1116,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([990,846],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1062,684],4,0,110)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -ControlPanel-([954,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38837448)
    Slider(38785120)
    Slider(38786792)
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,756],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,828],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([792,792],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1332,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1332,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([954,846],0,38813656,80)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([954,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38840856)
    Slider(38788768)
    Slider(38813656)
    }
   0.tbreakn([1062,864],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1116,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1152,864],6,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1080,774],0,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1080,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1422,1188],0,0,100)
    {
    Name = "FType"
    }
   0.logic([1152,684],0,0,120)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1188,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1188,648],0,38837448,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1296,684],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1188,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([972,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,954,1080,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([954,540],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,540,1116,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1188,810],6,38840856,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1224,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1296,828],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1260,828],0,0,160)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1260,684],6,0,130)
    {
    Type = "2"
    Inv = "0"
    }
   0.export([1422,1080],4,0,190)
    {
    Name = "B"
    }
   0.tfaultn([756,792],4,0,140)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([486,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,108,648,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([486,216],1,0,-1)
    {
    }
   -ControlPanel-([54,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 54,252
    Extents = 0,0,504,126
    Slider(39055992)
    Meter(39103232)
    Meter(39105224)
    Slider(39057968)
    Meter(39016584)
    Meter(39095016)
    Meter(39097096)
    }
   -ControlPanel-([54,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 54,396
    Extents = 0,0,504,126
    Slider(39052048)
    Meter(39107216)
    Meter(39109208)
    Slider(39054008)
    Meter(39018576)
    Meter(39099088)
    Meter(39101104)
    }
   0.var([594,756],0,38907032,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.22"
    Units = "s"
    Collect = "1"
    }
   0.var([594,828],0,38909120,50)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = ""
    Collect = "1"
    }
   -Sticky-([270,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 270,864,396,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No fault  (0)
11=> "
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2:
          Between T1
          and  B1
  3=> FT3:
          Midpoint on Line 1
          between T1 and T2
  4=> FT4:
          Between T2 
          and B2
  5=> FT5:
          Between Source
          and B2"
    }
   -Sticky-([738,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,108,846,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Sticky-([738,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,450,900,612
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT 
          record data.

You can turn on or off
each recorder individually."
    }
   -ControlPanel-([756,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(39124560)
    Switch(39126440)
    }
   -ControlPanel-([756,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(39120216)
    Slider(39009352)
    }
   -Divider-([54,630],0)
    {
    Size(882,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([702,90],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([936,90],0)
    {
    Size(0,1116)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144440545
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([558,522],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([360,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([540,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([810,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([990,396],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([990,1080],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([990,1116],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([990,1152],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1116,1080],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1116,1116],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1152,1080],0,38947520,610)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1152,1116],0,38949872,530)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1026,1026],0,38951864,290)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1152,954],0,38953856,200)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1152,990],0,38955848,260)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1278,954],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1278,990],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1278,1026],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1314,954],0,38959496,700)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1404,954],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1404,990],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1440,954],0,38962640,690)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1440,1026],0,38964544,640)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1026,990],0,38966448,240)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1314,990],0,38968440,680)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1440,990],0,38970344,670)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1026,1116],0,38972248,550)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.datalabel([540,846],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([576,846],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([612,846],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([540,1026],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([576,1026],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([612,1026],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([990,954],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([990,990],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1116,990],2,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([432,846],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([468,846],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([504,846],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([432,1026],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([468,1026],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([504,1026],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([414,396],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([936,396],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([360,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([342,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([1152,1026],0,38984416,310)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1278,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1152],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1278,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1188],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1404,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1188],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1116,954],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1404,1152],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1404,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1116],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1404,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1080],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1404,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1026],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1116,1152],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1116,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,1026],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1098,1026],0,0,300)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1098,990],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1098,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([990,1026],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([972,1026],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1278,1116],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1314,1026],0,39006656,650)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([1098,954],0,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1080,918],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([306,954],0,39009352,120)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1422,432],2,0,390)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1422,432],6,0,-1)
    {
    Name = "B2"
    }
   0.pgb([1026,1080],0,39012600,630)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1026,954],0,39014592,160)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1314,846],0,39016584,110)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1314,882],0,39018576,130)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1386,432],2,0,400)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([378,522],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([756,864],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([792,864],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([378,540],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([756,1116],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1386,432],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1404,504],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([810,1026],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,540],0,0,-1)
    {
    Name = "F2"
    }
   0.pgb([1026,1152],0,39026288,510)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1152,1152],0,39028288,490)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   -Wire-([1116,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([990,1188],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([1026,1188],0,39036624,470)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.datalabel([1116,1188],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1152,1188],0,39039152,450)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.datatap([756,864],6,0,770)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([828,864],6,0,750)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,864],6,0,740)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,864],2,0,-1)
    {
    Name = "FT3"
    }
   0.datatap([756,1116],0,0,620)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([828,1116],0,0,590)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([792,1116],0,0,-1)
    {
    Name = "F2"
    }
   0.datatap([792,1116],0,0,600)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1116],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([702,990],0,39046632,170)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "3"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([774,990],0,0,190)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([810,990],4,0,360)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([774,954],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([810,954],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([810,990],5,0,-1)
    {
    Name = "FType"
    }
   0.var([1062,468],5,39052048,50)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1116,468],5,39054008,60)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([288,468],3,39055992,40)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([234,468],3,39057968,30)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Sticky-([216,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,504,306,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.tpflt([522,504],0,0,800)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var([738,1188],0,39061056,320)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   -Sticky-([936,828],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,828,1044,864
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.recorder2_0([504,1098],0,0,660)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([612,990],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([612,1170],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([738,1170],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([1080,918],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([954,918],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([972,954],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([954,918],2,0,-1)
    {
    Name = "V1"
    }
   0.datatap([972,1026],0,0,280)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([972,990],0,0,230)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([342,504],0,0,810)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([774,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([828,1188],0,0,-1)
    {
    Name = "Ron"
    }
   -Wire-([828,396],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.tpflt([828,504],4,0,790)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([792,540],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([792,522],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([648,450],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([972,540],0,0,-1)
    {
    Name = "F5"
    }
   0.tpflt([1008,504],4,0,780)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([972,522],0,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([792,918],0,0,710)
    {
    DPath = "0"
    }
   -Wire-([738,882],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([792,864],6,0,760)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,864],6,0,730)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,864],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([900,864],2,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([792,1062],6,0,380)
    {
    DPath = "0"
    }
   0.datatap([864,1116],0,0,580)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([738,1098],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([900,1116],0,0,570)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1116],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([900,1116],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([522,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breaker3([900,396],0,0,410)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "116.7 [MW]"
    Q = "-18.39 [MVAR]"
    }
   0.breaker3([450,396],4,0,420)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-114.6 [MW]"
    Q = "15.09 [MVAR]"
    }
   0.source3R([270,396],6,0,330)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datalabel([1278,1080],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1314,1080],0,39095016,560)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1116],0,39097096,520)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1080],0,39099088,540)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1116],0,39101104,500)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1152],0,39103232,480)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1188],0,39105224,440)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1152],0,39107216,460)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1188],0,39109208,430)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Wire-([666,396],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([648,432],0,0,-1)
    {
    Name = "FT3"
    }
   0.var_pot([882,990],2,39112008,220)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.recorder2_0([504,918],0,0,720)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([126,882],1,0,90)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([162,918],6,0,350)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([108,1062],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([18,954],0,39120216,100)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([360,918],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.select([144,1098],6,0,270)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([360,1098],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([54,1134],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([378,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([54,954],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([54,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([162,846],1,39124560,80)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([144,1026],1,39126440,140)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   .Controls([1512,486],4,0,370)
    {
    }
   0.datalabel([1404,468],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1404,450],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1476,468],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1476,504],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.tpflt([684,414],4,0,820)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -TLine-([558,396],0,32879176,-1)
    {
    Name = "T1"
    Date = 1144440545
    Freq = "$(f)"
    Length = "50.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_Ground([630,702],0,22886528,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_Tower_3_Delta([756,612],0,22887656,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.Line_FrePhase_Options([216,468],0,22930600,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([540,126],0,22930968,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Out_Disp([972,198],0,0,-1)
      {
      DataF = "60.0"
      Zero_Tol = "1.0E-19"
      Vbase = "230"
      MVAbase = "100"
      picomp = "1"
      Rip = "1.0E5"
      }
     }
    }
   -TLine-([666,396],0,22931920,-1)
    {
    Name = "T2"
    Date = 1144440546
    Freq = "$(f)"
    Length = "50.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_Ground([630,702],0,22933176,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_Tower_3_Delta([702,612],0,23704328,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.SequenceInfo([522,126],0,23706056,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,23706712,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     }
    }
   0.source3R([1080,396],2,0,340)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([1044,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 1044,486,1134,522
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Plots([1512,612],0,0,70)
    {
    }
   -Sticky-([54,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,36,666,234
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line
   divide into 2 line sections, T1 and T2.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Five fault positions for full fault control ahead and behind station relays and Mid line
- Two breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -Sticky-([846,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 846,36,1242,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([36,774],0)
    {
    Size(1476,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([504,396],0,0,10)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([846,396],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([1278,846],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1278,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,882],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1278,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 }

